#ifndef __C_SIMNETLAYERPARAM_H
#define __C_SIMNETLAYERPARAM_H

#define WIN32_LEAN_AND_MEAN

#include "Interfaces/cParam.h"
#include <windows.h>

class cSimEngine;

/*
 * cSimNetLayerParam.h
 *
 * Parameter set for the simulated network layer.
 */
class cSimNetLayerParam: public cParam
{
  public:

	cSimNetLayerParam() { ResetToDefault(); }

	void ResetToDefault()
	{
		mEngine				   = NULL;
		mNumSubnets			   = 5;
		mNumAddressesPerSubnet = 5;
		mSubnetToSubnetLatency = 15;	// ms
		mInternalSubnetLatency = 8;		// ms
		mSubnetToSubnetFudge   = 7;		// ms
		mInternalSubnetFudge   = 6;		// ms
		mRecvOwnMulticasts     = true;
	}

	cSimEngine*	 mEngine;
	unsigned int mNumSubnets;
	unsigned int mNumAddressesPerSubnet;
	DWORD		 mSubnetToSubnetLatency;
	DWORD		 mInternalSubnetLatency;
	DWORD		 mSubnetToSubnetFudge;
	DWORD		 mInternalSubnetFudge;
	bool		 mRecvOwnMulticasts;
};

#endif